
//Weibull Distribution
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

deff('[ww]=w(x,a,b)','ww=a.*b.*x^(b-1).*exp(-a.*x.^b)')              //pdf
deff('[WW]=W(x,a,b)','WW=1-exp(-a.*x.^b)')                           //cdf
//alpha=2,beta=3
xx=(0:0.01:2);
yy=w(xx,2,3);
figure
xlabel('x');
ylabel('fX(x)');
title('Weibull distribution');
plot(xx,yy,'x')
yyy=[];
for x=0:0.01:2, yyy=[yyy W(x,2,3)]; end;
figure
xlabel('x');
ylabel('FX(x)');
title('Weibull distribution');
plot(xx,yyy,'x')

//Probability calculations
//P(X<1.5)
p1=W(1.5,2,3)
disp(p1,'P(X<1.5)')

//P(X>0.6)
p2=1-W(0.6,2,3)
disp(p2,'P(X>0.6)')

//P(0.5<X<1.2)
p3=W(1.2,2,3)-W(0.5,2,3)
disp(p3,'P(0.5<X<1.2)')
